//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.10 Page 330
//Title: Average Temperature of the Aluminum Plate
//======================================================
model Ex6_10

//==========
//Parameter Section

parameter Real nu(unit = "m^2/s") = 1.578e-5 "Kinematic Viscosity of Air at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.02623 "Thermal Conductivity of Air at Mean Film Temperature";
parameter Real Pr = 0.713 "Prandtl Number of Air at Mean Film Temperature";

//==========
//Variable Section

input Real l(unit = "m",start = 2) "Length of the Aluminum Plate";
input Real q(unit = "W/m^2",start = 1e3) "Power Density";
input Real uair(unit = "m/s",start = 10) "Velocity of Air";
input Real Tair(unit = "K",start = 290) "Temperature of Air";
input Real Ret(start = 4e5) "Reynolds Number at the end of Turbulent Transition Regime";
output Real Tap(unit = "K") "Average Temperature of the Aluminum Plate";
Real ha(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
Real Tf(unit = "K") "Mean Film Temperature";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";

//==========
//Equation Section

equation
Re = uair*l/nu;
Tf = 300;
Nu = 0.037*(Pr^0.43)*((Re^0.8)-((Ret^0.8)-(17.95*(Pr^(-0.097))*(Ret^0.5))));
ha = Nu*K/l;
Tap = Tair+(q/ha);
//If the above procedure is followed by taking Property Values at Higher Temperature (310 K), new Values for ha and Tap are obtained. The new value of ha differs from that obtained above by 30% approximately. The new value of Tap differs from the value obtained above by 1.3 K.
end Ex6_10;
//======================================================
