//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.2 Page 287
//Title: Boundary Layer Thickness
//======================================================
model Ex6_2

//==========
//Parameter Section

parameter Real mu(unit = "kg/(m s)") = 1.853e-5 "Dynamic Viscosity of Air";
parameter Real nu(unit = "m^2/s") = 1.566e-5 "Kinematic Viscosity of Air";

//==========
//Variable Section

input Real Tair(unit = "deg C",start = 27) "Temperature of Air";
input Real uair(unit = "m/s",start = 1.5) "Velocity of Air ";
input Real x(unit = "m",start = 0.5) "Distance from the Leading Edge";
output Real delta(unit = "m") "Boundary Layer Thickness";
Real Re "Reynolds Number";
Real v(unit = "m/s") "Velocity of Air outside the Boundary Layer Edge";
Real vu "v/uair";

//==========
//Equation Section

equation
Re = uair*x/nu;     //Reynolds Number Calculation
//Since Reynolds Number, Re < 5e5, Laminar Flow Analysis is valid
delta = (4.92*x)/(Re^0.5);
//delta/x = 0.0225, which is very much less than 1. Therefore Boundary Layer Analysis is valid
v = 0.8604/((x/(nu*uair))^0.5);     //From Table 6.1 (Page 285), it can be observed that the ratio of v:u is greatest beyond the outside edge of the Boundary Layer, at large neta. The value of neta is found out to be, neta = 8
vu = v/uair;      //The Value of v/uair is very much less than 1. Therefore uair >> v at the Trailing Edge.
end Ex6_2;
//======================================================
