//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 6: Laminar and Turbulent Boundary Layers
//Example: 6.8 Page 314
//Title: Drag Force on Heat Transfer Surface
//======================================================
model Ex6_8

//==========
//Parameter Section

parameter Real Pr = 0.707 "Prandtl Number at Mean Film Temperature";
parameter Real K(unit = "W/(m K)") = 0.02885 "Thermal Conductivity of Air at Mean Film Temperature";
parameter Real nu(unit = "m^2/s") = 0.0000194 "Kinematic Viscosity of Air at Mean Film Temperature";
parameter Real rho(unit = "kg/m^3") = 1.05 "Density of Air at Mean Film Temperature";

//==========
//Variable Section

input Real uair(unit = "m/s",start = 15) "Velocity of Air";
input Real l(unit = "m",start = 0.5) "Length of the Plate";
input Real b(unit = "m",start = 0.5) "Breadth or Width of the Plate";
output Real F(unit = "N") "Drag Force exerted by air on the Heat Transfer Surface";
Real A(unit = "m^2") "Area of the Plate";
Real Cf "Skin Friction Coefficient";
Real Taua(unit = "kg/(m s^2)") "Average Shear Stress";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";

//==========
//Equation Section

equation
Re = 386598;      //Refer Example 6.5
Nu = 367.794;     //Refer Example 6.5
A = l*b;
Cf = (2*Nu)/(Re*(Pr)^(1/3));
Taua = Cf*rho*(uair^2)/2;
F = Taua*A;
end Ex6_8;
//======================================================
