//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 7: Forced Convection in a Variety of Configurations
//Example: 7.1 Page 352
//Title: Heat Transfer in Pipes
//======================================================
model Ex7_1

//==========
//Parameter Section

parameter Real K(unit = "W/(m K)") = 0.6367 "Thermal Conductivity of Water at Mean Film Temperature";
parameter Real nu(unit = "m^2/s") = 0.556e-6 "Kinematic Viscosity of Water at Mean Film Temperature";
parameter Real alpha(unit = "m^2/s") = 1.541e-7 "Thermal Diffusivity of Water at Mean Film Temperature";

//==========
//Variable Section

input Real Twi(unit = "deg C",start = 20) "Inlet Temperature of Water";
input Real d(unit = "m",start = 1e-3) "Diameter of the Small-Bore Tube";
input Real u(unit = "m/s",start = 0.2) "Velocity of Water through the Tube";
input Real q(unit = "W/m^2",start = 6000) "Constant Heat Flux established after a point in the Tube";
input Real Two(unit = "deg C",start = 74) "Outlet Temperature of Water";
output Real l(unit = "m") "Length down the Tube where Water attains Outlet Temperature";
Real Re "Reynolds Number";
Real Tf(unit = "deg C") "Mean Film Temperature";

//==========
//Equation Section

equation
Tf = (Two+Twi)/2;   //Mean Film Temperature
Re = (d*u)/nu;      //Reynolds Number Calculation
l/d = ((Two-Twi)-((11/48)*(q*d/K)))*((u*K)/(4*q*alpha));
//Refer Page 352
end Ex7_1;
//======================================================
