//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 7: Forced Convection in a Variety of Configurations
//Example: 7.5 Page 370
//Title: Temperature of Air in Pipe
//======================================================
model Ex7_5

//==========
//Parameter Section

parameter Real nu(unit = "m^2/s") = 1.66e-5 "Kinematic Viscosity of Air";
parameter Real Pr = 0.709 "Prandtl Number of Air";
parameter Real K(unit = "W/(m K)") = 0.0268 "Thermal Conductivity of Air";
parameter Real rho(unit = "kg/m^3") = 1.14 "Density of Air";
parameter Real Cp(unit = "J/(kg K)") = 1007 "Specific Heat Capacity of Air";

//==========
//Variable Section

input Real Tai(unit = "deg C",start = 20) "Inlet Temperature of Air";
input Real d(unit = "m",start = 1e-2) "Diameter of the Pipe";
input Real u(unit = "m/s",start = 0.7) "Average Velocity of Air through the Pipe";
input Real Tw(unit = "deg C",start = 60) "Wall Temperature of the Section of Pipe";
input Real l(unit = "m",start = 0.25) "Length down the Pipe";
output Real Tl(unit = "deg C") "Temperature at the required point in the Pipe";
Real havg(unit = "W/(m^2 K)") "Average Heat Transfer Coefficient";
Real Re "Reynolds Number";
Real Nu "Nusselt's Number";
Real Gz "Graetz Number";

//==========
//Equation Section

equation
Re = u*d/nu;
Gz = Re*Pr*d/l;
Nu = 3.657+((0.0668*(Gz^(1/3)))/(0.04+(Gz^(-2/3))));
//Refer Page 355, equation 7.29
havg = Nu*K/d;
(Tl-Tai) = (Tw-Tai)*(1-(exp((-4*havg*l)/(rho*u*Cp*d))));
//Refer Page 370, equation 7.59b
end Ex7_5;
//======================================================
//Remark
//The Value of Nusselt's Number, Nu = 4.32. But in the textbook (Page 371), the Value of Nusselt's Number is taken to be, Nu = 3.657 in calculating havg.
