//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 8: Natural Convection in Single Phase Fluids and during Film Condensation
//Example: 8.6 Page 438
//Title: Film Condensation of Water
//======================================================
model Ex8_6

//==========
//Parameter Section

parameter Real hfg(unit = "kJ/kg") = 2257 "Latent Heat of Vapourization of Water";
parameter Real Cp(unit = "kJ/(kg K)") = 4.211 "Specific Heat Capacity of Water";
parameter Real K(unit = "W/(m K)") = 0.677 "Thermal Conductivity of Water";
parameter Real mu(unit = "kg/(m s)") = 2.99e-4 "Dynamic Viscosity of Water";
parameter Real rhow(unit = "kg/m^3") = 961.9 "Mass Density of Water";
parameter Real rhog(unit = "kg/m^3") = 0.6 "Mass Density of Water Vapour";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity at the Earth's Surface";
parameter Real Tb(unit = "deg C") = 100 "Boiling Point of Water at Atmospheric Pressure";
parameter Real Pr = 1.86 "Prandtl Number of Water";

//==========
//Variable Section

input Real l(unit = "m",start = 0.3) "Length of the Strip";
input Real Ts(unit = "deg C",start = 90) "Temperature of the Strip";
output Real Hfg(unit = "kJ/kg") "Corrected Latent Heat of Vapourization of Water";
output Real delta(unit = "m") "Film Thickness at the Bottom";
output Real m(unit = "kg/(m s)") "Condensate Mass Flow Rate per Metre";
output Real Q(unit = "kW/m") "Rate of Heat Transfer per unit Length";
Real Nu "Nusselt's Number";
Real q(unit = "W/m^2") "Heat Flux";

//==========
//Equation Section

equation
Hfg = hfg*(1+(0.683-(0.228/Pr))*(Cp*(Tb-Ts)/hfg));
delta = ((4*K*(Tb-Ts)*mu*l)/(rhow*(rhow-rhog)*g*Hfg*1000))^0.25;
Nu = ((4*l)/(3*delta));
q = Nu*K*(Tb-Ts)/l;
Q*1000 = q*l;
m = Q/Hfg;
end Ex8_6;
//======================================================
