//John H. Lienhard IV and John H. Lienhard V, A Heat Transfer Textbook, Fourth Edition, Phlogiston Press, Cambridge, MA, USA, 2017

//Chapter 9: Heat Transfer in Boiling and Other Phase Change Configurations
//Example: 9.5 Page 484
//Title: Heat Flux
//======================================================
model Ex9_5

//==========
//Parameter Section

parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to Gravity";
parameter Real hfg(unit = "J/kg") = 2257e3 "Latent Heat of Vapourization of Water";
parameter Real rhof(unit = "kg/m^3") = 958.2 "Density of the Liquid";
parameter Real rhog(unit = "kg/m^3") = 0.597 "Density of the Gas";
parameter Real sigma(unit = "N/m") = 0.0589 "Surface Tension of the Liquid";

//==========
//Variable Section

output Real qmax(unit = "W/m^2") "Maximum Heat Flux";

//==========
//Equation Section

equation
qmax = 0.149*(rhog^0.5)*hfg*((g*(rhof-rhog)*sigma)^0.25);
end Ex9_5;
//======================================================
