class Ex1_5
parameter Real W (unit = "ft")=14; // Width in ft
parameter Real L (unit = "ft")=30; // Length in ft
parameter Real A (unit = "ft^2")=W*L; // Area in ft^2
parameter Real F_12=1; // View factor taken as 1
parameter Real T1 (unit = "Rankine")=120+460; // Driveway surface temperature  in Rankine
parameter Real T2 (unit = "Rankine")=0; // Space temperature assumed to be 0 Rankine
parameter Real sigma (unit = "BTU/(hr.ft^2.(Rankine)^4)")=0.1714*10^(-8); // Value of Stefan-Boltzmann's constant in BTU/(hr.ft^2.(Rankine)^4)
parameter Real e=0.9; // Surface emissivity
Real q (unit = "BTU/hr");//Instantaneous heat loss rate in BTU/hr
equation
q=sigma*A*e*F_12*((T1)^4-(T2)^4);
end Ex1_5;