class Ex12_3
//  Determination of the heat transferred by radiation from dA1 to A. 
// The view factor Fd1_2 can be calculated as Fd1_2=Fd1_3+Fd1_4+Fd1_5
// For Fd1_3
parameter Real a_13=100;
parameter Real b_13=250;
parameter Real c_13=100;
Real X_13;//For 1-3 the values of a/c
Real Y_13;//For 1-3 the values of b/c
parameter Real Fd1_3=0.17; // value for Fd1_3 corresponding to above calculated values of a/c and b/c
// For Fd1_4
parameter Real a_14=300;
parameter Real b_14=50;
parameter Real c_14=100;
Real X_14;//For Fd1_4, the value of a/c
Real Y_14;//For Fd1_4, the value of b/c 
parameter Real Fd1_4=0.11; //value for Fd1_4 corresponding to above calculated values of a/c and b/c
// For Fd1_5
parameter Real a_15=100;
parameter Real b_15=50;
parameter Real c_15=100;
Real X_15;//For Fd1_5, the value of a/c
Real Y_15;//For Fd1_5, the value of b/c 
parameter Real Fd1_5=0.09; //value for Fd1_3 corresponding to above calculated values of a/c and b/c
Real Fd1_2;//the fraction of energy energy leaving dA1 reaches A
parameter Real sigma (unit = "BTU hr^−1 ft^−2 °R^−4")=0.1714e-8; // Stefan-Boltzmann constant
parameter Real T1 (unit = "degree R")=660;
parameter Real T2 (unit = "degree R")=560;
Real q12_A1 (unit = "BTU/(hr.sq.ft");//The net heat transferred in BTU/(hr.sq.ft)

equation
X_13=a_13/c_13;
Y_13=b_13/c_13;
X_14=a_14/c_14;
Y_14=b_14/c_14;
X_15=a_15/c_15;
Y_15=b_15/c_15;
Fd1_2=Fd1_3+Fd1_4-Fd1_5;
q12_A1=sigma*Fd1_2*(T1^4-T2^4);
end Ex12_3;