class Ex2_1
parameter Real T3 (unit = "degree Fahrenheit") =-10; // Temperature of inside wall in Fahrenheit
parameter Real T0 (unit = "degree Fahrenheit")= 70; // Temperature of outside wall in Fahrenheit
parameter Real dT (unit = "degree Fahrenheit")=T0-T3; // overall temperature difference
// Values of thermal conductivity from appendix table B3
parameter Real k1 (unit = "BTU/(hr.ft.degree Rankine)")=0.38; // Brick masonry BTU/(hr.ft.degree Rankine)
parameter Real k2 (unit = "BTU/(hr.ft.degree Rankine)")=0.02; // Glass fibre  BTU/(hr.ft.degree Rankine)
parameter Real k3 (unit = "BTU/(hr.ft.degree Rankine)")=0.063; // Plywood BTU/(hr.ft.degree Rankine)
parameter Real dx1 (unit = "ft")=4/12; // thickness of brick layer in ft
parameter Real dx2 (unit = "ft")=3.5/12; // thickness of glass fibre layer in ft
parameter Real dx3 (unit = "ft")=0.5/12; // thickness of plywood layer in ft
parameter Real A (unit = "ft^2")=1; // cross sectional area taken as 1 ft^2
Real R1 (unit = "(hr.degree Rankine)/BTU"); // Resistance of brick layer in (hr.degree Rankine)/BTU
Real R2 (unit = "(hr.degree Rankine)/BTU"); // Resistance of glass fibre layer in (hr.degree Rankine)/BTU
Real R3 (unit = "(hr.degree Rankine)/BTU"); // Resistance of plywood layer in (hr.degree Rankine)/BTU 
Real qx (unit = "BTU/ft^2.hr"); // Heat flow through the composite wall per-square-foot
equation
R1=dx1/(k1*A); 
R2=dx2/(k2*A); 
R3=dx3/(k3*A);
qx=(T0-T3)/(R1+R2+R3); 

end Ex2_1;