class Ex2_2
import Modelica.SIunits.*; 
parameter ThermalConductivity k1=0.45;// Thermal conductivity of brick
parameter ThermalConductivity k2a=0.15; // Thermal conductivity of pine
parameter ThermalConductivity k3=0.814; // Thermal conductivity of plaster board
parameter ThermalConductivity k2b=0.025; // thermal conductivity of air from appendix D1
parameter Area A1=0.41*3; // cross sectional area of brick layer 
parameter Area A2a=0.038*3; // cross sectional area of wall stud
parameter Area A2b=(41-3.8)*0.01*3; // cross sectional area of air layer
parameter Area A3=0.41*3; // Cross sectional area of plastic layer 
parameter Length dx1=0.1; // Thickness of brick layer in m
parameter Length dx2=0.089; // Thickness of wall stud and air layer in m
parameter Length dx3=0.013; // Thickness of plastic layer in m
parameter Temperature T1=25+273.15; // Temperature of inside wall in celsius
parameter Temperature T0=0+273.15; // Temperature of outside wall in celsius
ThermalResistance R1; // Resistance of brick layer in K/W
ThermalResistance R2; // Resistance of wall stud and air layer in K/W
ThermalResistance R3; // Resistance of plastic layer in K/W
Power qx; // Heat transfer through the composite wall in W
equation
R1=dx1/(k1*A1);
R2=dx2/(k2a*A2a+k2b*A2b); 
R3=dx3/(k3*A3); 
qx = (T1-T0)/(R1+R2+R3);
end Ex2_2;