class Ex2_5
// determination of the heat gain per unit length
parameter Real k1 (unit = "BTU/(hr.ft.degree Rankine)")=231; // thermal conductivity of copper in BTU/(hr.ft.degree Rankine)from appendix table B1 
parameter Real k2 (unit = "BTU/(hr.ft.degree Rankine)")=0.02; // thermal conductivity of insulation in BTU/(hr.ft.degree Rankine)
// Specifications of 1 standard type M copper tubing from appendix table F2 are as follows
parameter Real D2 (unit = "ft")=1.125/12; // outer diameter in ft
parameter Real D1 (unit = "ft")=0.08792; // inner diameter in ft
parameter Real R2 (unit = "ft")=D2/2;// outer radius
parameter Real R1 (unit = "ft")=D1/2; // inner radius
parameter Real t (unit = "ft")=0.5/12; // wall thickness of insulation in ft
parameter Real R3 (unit = "ft")=R2+t;
parameter Real T1 (unit = "°F")=40; // temperature of inside wall of tubing in degree fahrenheit
parameter Real T3 (unit = "°F")=70; // temperature of surface temperature of insulation degree fahrenheit
Real LRk1 (unit = "ft*°F·h/BTU(IT)");    // product of length and copper layer resistance
Real LRk2 (unit = "ft*°F·h/BTU(IT)");    // product of length and insulation layer resistance
Real q_per_L (unit = "BTU/(hr.ft)");   // heat transferred per unit length in BTU/(hr.ft)
equation
LRk1=(log(R2/R1))/(2*3.14*k1); 
LRk2=(log(R3/R2))/(2*3.14*k2); 
q_per_L=(T1-T3)/(LRk1+LRk2); 

end Ex2_5;