class Ex2_8
//Still erroneous
parameter Real k (unit = "")=24.8; // thermal conductivity of 1C steel in BTU/(hr.ft.degree Rankine)from appendix table B2
parameter Real D (unit = "ft")=(5/16)/12; // diameter of the rod in ft
parameter Real P (unit = "ft")=(3.14*D); // Circumference of the rod in ft
parameter Real A (unit = "ft^2")=(3.14/4)*D^2; // Cross sectional area of the rod in sq.ft
parameter Real hc (unit = " BTU/(hr. sq.ft. degree Rankine)")=1; // assuming the convective heat transfer coefficient as 1 BTU/(hr. sq.ft. degree Rankine)
parameter Real m (unit = "lb")= sqrt(hc*P/(k*A));
parameter Real L (unit = "ft")=(9/2)/12; // length of rod in ft
// using the equation (T-T_inf)/(T_w-T_inf)=(cosh[m(L-z)])/(cosh(mL)) for temperature profile
parameter Real T_inf (unit = "°F")=70; //Ambient temperature in Fahrenheit
parameter Real T_w (unit = "°F")=200;  //Uniform elevated temperature in Fahrenheit
parameter Real dT (unit = "°F")=T_w-T_inf; //Difference in temperature
parameter Real mL (unit = "lb.ft") = m*L;
parameter Real efficiency=0.78;
Real T (unit = "°F");
Real const (unit = "°F/lb.ft");
// the heat transferred can be calculated using the equation qz=k*A*m*(T_w-T_inf)*tanh(m*L)
Real qz (unit = "BTU/(hr)");
// the effectiveness can be found using the equation effectiveness=sqrt(k*P/h*A)*tanh(mL)
Real effectiveness;

equation
const=dT/cosh(mL);
T = T_inf+const*cosh(m*(L-time));
qz=k*A*m*dT*tanh(mL);
effectiveness=sqrt(k*P/(hc*A))*tanh(mL);
end Ex2_8;