class Ex4_5
parameter Real hc (unit = "BTU/(lbm.°R)")=6;// Heat transfer Coeff
parameter Real D (unit = "BTU/(lbm.°R)")=0.105;//Dia. of pipe
parameter Real k (unit = "BTU/(hr.ft.°R)")=0.3;//Thermal conductivity of soil
parameter Real c (unit = "BTU/(lbm.°R)")=0.41;//Specific heat capacity of soil
parameter Real sp_gr=2.1;//Specific gravity of soil
parameter Real rho_water (unit = "lb/ft^3")=62.4;//Density of water
Real alpha (unit = "ft^2/hr");//The diffusivity of the soil 
parameter Real t (unit = "hours")=3*30*24;//Time in hours
// Bi_sqrt(Fo) is infinite
parameter Real T_inf (unit = "°R")=10;
parameter Real Ts (unit = "°R")=10;//Surface temperature
parameter Real T (unit = "°R")=32;// soil temperature
parameter Real T_i (unit = "°R")=70;//Initial soil temperature
Real dimensionless_temp;//The dimensionless temperature
Real variable_fig4_12;//The value of x/(2*(alpha*t)^0.5) from figure 4.12
Real x (unit = "ft");//The depth of the freeze line in soil
equation
alpha=k/(sp_gr*rho_water*c);
dimensionless_temp=(T-T_i)/(T_inf-T_i);
variable_fig4_12=0.38; 
x=2*sqrt(alpha*t)*variable_fig4_12;
end Ex4_5;