class Ex4_8
import Modelica.SIunits.*;
parameter Density rho=7817;
parameter SpecificHeatCapacity c=461;
parameter ThermalConductivity k=14.4;
parameter ThermalDiffusivity alpha=.387e-5;
parameter Length L1=0.03;//Width of infinite bar
parameter Length L2=0.03;//length of infinite bar
parameter Length L3=0.04;//Length from bottom for calc
parameter Length x=0.04;
parameter Temperature T_i=95 + 273.15;//Initial Temperature
parameter Temperature T_inf=17 + 273.15;//Water Temperature
// for infinite plate
parameter Length L=L1/2;
parameter CoefficientOfHeatTransfer hc=50;// Heat transfer Coeff
Real reciprocal_Bi_plate;//The value of 1/Bi for infinite plate 
parameter Integer n=1;
parameter Time[7] t={3000, 1500, 700, 400, 200, 300, 350};
parameter Real[7] dim_T_plate={0.085, 0.34, 0.55, 0.7, 0.8, 0.8, 0.7}; //the corresponding values of dimensionless temperature for infinite plate from figure 4.6a
parameter Real[7] dim_T_solid={0.225, 0.14, 0.075, 0.046, 0.02, 0.035, 0.042}; // the corresponding values of dimensionless temperature for semi-infinite solid from figure 4.12
Real[7] parameter1;// parameter for infinite plate Fourier Number,Fo is named as parameter1
Real[7] parameter2;// parameter for semi-infinite solid Bi(Fo)^0.5 and  is named as parameter2
Real[7] parameter3; //parameter for semi-infinite solid x/(2*(alpha*t)^0.5) is named as parameter3
Real dim_T_bar[7];
Temperature T[7];
algorithm
reciprocal_Bi_plate:=k/(hc*L);

for i in 1:7 loop
  parameter1[i]:=alpha*t[i]/L^2;  parameter2[i]:=hc*((alpha*t[i])^0.5)/k;
  parameter3[i]:=x/(2*(alpha*t[i])^0.5);
  dim_T_bar[i]:=dim_T_plate[i]*dim_T_plate[i]*(1-dim_T_solid[i]);
  T[i]:=dim_T_plate[i]*dim_T_plate[i]*(1-dim_T_solid[i])*(T_i-T_inf)+T_inf;
end for;

end Ex4_8;