class Ex5_2
import Modelica.SIunits.*;
// properties of Freon-12 from appendix table C3
parameter Real T1_Fr=-50+273.15; // Initial temp in kelvin
parameter Real T2_Fr=-40+273.15; // Final temp in kelvin
parameter Real rho1_Fr=1.546*1000; // Initial Density in kg/m^3
parameter Real rho2_Fr=1.518*1000; // Final Density in kg/m^3
Real beta_Fr; //The volumetric thermal expansion coefficient for Freon-12
parameter Real beta_acc_Fr=2.63e-3; // the accurate value of volumetric thermal expansion coefficient for Freon-12 in per kelvin
Real error_Fr; //The error introduced in the case of Freon-12
// properties of helium from appendix table D3
parameter Real T1_He=366;// Initial temp in kelvin
parameter Real T2_He=477; // Final temp in kelvin
parameter Real rho1_He=0.13280; // Initial Density in kg/m^3
parameter Real rho2_He=0.10204;  // Final Density in kg/m^3
Real beta_He;//The volumetric thermal expansion coefficient for Helium in per kelvin
equation
beta_Fr=-(rho1_Fr-rho2_Fr)/(rho1_Fr*(T1_Fr-T2_Fr));
error_Fr=(beta_acc_Fr-beta_Fr)*100/beta_acc_Fr;
beta_He=-(rho1_He-rho2_He)/(rho1_He*(T1_He-T2_He));
end Ex5_2;