class Ex1_4
  import Modelica.SIunits.*; 
  parameter Length D=2.43/100; // Diameter of pipe in meter
  parameter Length L=20/100; // Length of pipe in meter
  parameter Area A=3.14*D*L; // Cross-sectional area of pipe in sq.m
  parameter SpecificHeatCapacity cp=4200; // Specific heat of water in J/kg.K
  parameter Temperature T_b2=21.4+273.15; // Temperature of bulk fluid in celsius
  parameter Temperature T_in=20+273.15; // Temperature of inlet water in celsius
  parameter Temperature T_w=75+273.15; // Temperature of wall in celsius
  parameter VolumeFlowRate Q=500; // Volumetric flow rate in cc/s
  parameter Density density=1000; // Density of water in kg/m^3
  parameter MassFlowRate m=Q*density/10^6; // Mass flow rate in kg/s
  Real hc;// Average film conductance in W/(m^2*K)
  equation
  hc=m*cp*(T_b2-T_in)/(A*(T_w-T_in));
end Ex1_4;