class Ex10_3
import Modelica.SIunits.*;
// Calculation of (a) the power input to the water for boiling to occur, (b) the evaporation rate of water, and (c) the critical heat flux.
// properties of water at 100°C = 373 K from appendix table 10.3
parameter Density rho_f=958; // density in kg/m^3
parameter SpecificHeatCapacity cp_f= 4217; // specific heat in J/(kg*K) 
parameter KinematicViscosity v_f= 2.91e-7; // viscosity in m^2/s  
parameter Real Pr_f =1.76; // Prandtl Number 
parameter Density rho_g=0.596; 
parameter SurfaceTension sigma =0.0589; // surface tension in N/m
parameter SpecificEnergy hfg=2257000; 
parameter Temperature Tw=120;
parameter Temperature Tg=100;
parameter Length D=0.141; // diameter of pan in m
parameter Acceleration g=9.81;//Gravitational acceleration in m/s^2
parameter Real gc=1;
// nucleate boiling regime
parameter Real Cw=0.0132; // for mechanically polished stainless steel from table 10.2
HeatFlux q_A;//The heat transferred per unit area in W/sq.m
Area A;//The area of the pan inside-bottom surface in contact with liquid in sq.m
Power q; // power delivered to the water in W
MassFlowRate mf; // water evaporation rate in kg/s
HeatFlux q_cr;//The critical heat flux in W/sq.m

equation
q_A=(rho_f*v_f*hfg)*((g*rho_f*(1-(rho_g/rho_f)))/(sigma*gc))^(1/2)*((cp_f*(Tw-Tg))/(Cw*hfg*Pr_f^1.7))^3;
A=3.1412*D^2/4;
q=q_A*A;
mf=q/hfg;
q_cr=0.18*hfg*(sigma*g*gc*rho_f*rho_g^2)^(1/4);
end Ex10_3;