class Ex11_4
import Modelica.SIunits.*;
// Determination of the percentage of total emitted energy that lies in the visible range. 
parameter Temperature T=2800;//Temperature of emission in K
parameter Length lambda1=4e-7;//Wavelength 1 in m
parameter Length lambda2=7e-7;//Wavelength 2 in m
Real hT (unit = "m.K");//hT
Real lambdaT (unit = "m.K");//lambdaT
parameter Real I1=0.0051; //Fraction of Total Radiation Emitted for lower Wavelength-Temperature Product from Table 11.1
parameter Real I2=0.065; //Fraction of Total Radiation Emitted for upper Wavelength-Temperature Product from Table 11.1
Real dI;//The percentage of total emitted energy that lies in the visible range

equation
hT=lambda1*T;
lambdaT=lambda2*T;
dI/100=I2-I1;
end Ex11_4;