class Ex11_5
import Modelica.SIunits.*;
// Estimation of the surface temperature of the sun and the emitted heat flux
parameter Length lambda_max=0.5e-6; // maximum wavelength in m
// From Wien’s Displacement Law we can write lambda_max*T=2.898e-3 m.K
Temperature T;//The Surface Temperature of the Sun in K
parameter Real sigma (unit = "W/(m^2.K^4)")=5.675e-8; // value of Stefan-Boltzmann constant in W/(m^2.K^4)
HeatFlux q;//The heat flux emitted in W/sq.m

equation
T=2.898e-3/lambda_max;
q=sigma*T^4;
end Ex11_5;