class Ex12_8
// Determination of the net heat exchanged between the dish and the surroundings by radiation at the instant the dish is removed from the oven. Perform the calculations (a) if the dish and surroundings behave like black bodies, and again (b) if the dish has an emissivity of 0.82 and the surroundings have an emissivity of 0.93.
parameter Real D (unit = "feet")=12/12; // diameter in ft
parameter Real L (unit = "feet")=6/12; // length in ft
Real A (unit = "sq. ft");//The Surface area in sq.ft
parameter Real F12=1; // the view factor between the dish and the surroundings
parameter Real T1 (unit = "°R")=810;// the temperature of the dish in degree Rankine
parameter Real T2 (unit = "°R")=530;// the temperature of the surroundings in degree Rankine
parameter Real sigma (unit = "BTU hr^−1 ft^−2 °R^−4")=0.1714e-8; // Stefan-Boltzmann constant
Real q1 (unit = "BTU/hr");//The heat exchanged between the dish and the surroundings in BTU/hr
// q1/(A1e1)-[F11*(q1/A1)*(1-e1)/e1+F12*(q2/A2)*(1-e2)/e2]=sigma*T1^4-(F11*sigma*T1^4+F12*sigma*T2^4)... equation (1)
parameter Real F11=0;// the view factor between the dish and itself
parameter Real e1=0.82;//Emissivity for surface 1
parameter Real e2=0.93;//Emissivity for surface 2
// putting q2/A2=0 in equation (1) as A2 tends to infinity
Real q1_ (unit = "BTU/hr");//The heat exchanged between the dish and the surroundings for the second case in BTU/hr

equation
A=2*3.1412*D^2/4+3.1412*D*L;
q1=sigma*A*(T1^4-T2^4)*F12;
q1_=A*e1*(sigma*T1^4-F12*sigma*T2^4);
end Ex12_8;