class Ex4_3
import Modelica.SIunits.*;
parameter CoefficientOfHeatTransfer hc=30;// Heat transfer Coeff
parameter Length L=0.24;//Wall thickness
parameter ThermalConductivity k=1.25;//Thermal Conductivity
parameter SpecificHeatCapacity c=890;//Specific Heat Capacity
parameter Density rho=550; //Density
Real Bi;//Biot's number
ThermalDiffusivity alpha;//The value of diffusivity in sq.m/s
parameter Temperature Tc=150;
parameter Temperature T_inf=600;
parameter Temperature T_i=50;
Real reciprocal_Bi;
Real dimensionless_temp;
Time t; //The required time
Integer n;
parameter Integer m = 7;
parameter Real Fo = 0.4; //The value of Fourier Number
parameter Real[7] x_per_L={0, 0.2, 0.4, 0.6, 0.8, 0.9, 1.0};//The choosen values of x/L
parameter Real[7] dim_T={1.0, 0.97, 0.86, 0.68, 0.48, 0.36, 0.24}; // value for dimensionless temperature for corresponding value of x/L
Real[7] T;
Real[7] x;
Real[7] X;
algorithm
Bi:=hc*L/k;
alpha:=k/(rho*c);
if Bi<0.1 then
    n:=0;
else
    n:=1;
end if;

if n==1 then
    reciprocal_Bi:=1/Bi;
    dimensionless_temp:=(Tc-T_inf)/(T_i-T_inf);
    t:=L^2*Fo/alpha;
end if;
for i in 1:m loop
    T[i]:=dim_T[i]*dimensionless_temp*(T_i-T_inf)+T_inf;
    x[i]:=x_per_L[i]*L;
end for;
for i in 1:m loop
    X[i]:=x[i]*100;
end for;

end Ex4_3;