class Ex7_2
// determination of temperature profile
// properties of water at (40 + 100)/2 = 70°F = 68°F from appendix table C11
parameter Real rho (unit = "lbm/ft^3")= 62.4; // density in lbm/ft^3 
parameter Real cp (unit = "BTU/(lbm-°R)")=0.9988; // specific heat BTU/(lbm-°R) 
parameter Real v (unit = "sq.ft/s")= 1.083e-5; // viscosity in sq.ft/s 
parameter Real kf (unit = "BTU/(hr.ft.°R)") = 0.345 ; // thermal conductivity in BTU/(hr.ft.°R) 
parameter Real a (unit = "sq.ft/hr") = 5.54e-3; // diffusivity in sq.ft/hr 
parameter Real Pr = 7.02; // Prandtl Number
parameter Real V (unit = "ft/s")=1.2; // velocity in ft/s
parameter Real[2] x (unit = "ft")={1, 2}; // distances from plate entry in ft
parameter Real Tw (unit = "°F")=100; // temperature of metal plate in degree fahrenheit
parameter Real T_inf (unit = "")=40; // temperature of water in degree fahrenheit
Real[2] Re;// Reynolds Number at x=1 ft
Real[2] hL (unit = "BTU/(hr. sq.ft. °R");//The average convection coefficient in BTU/(hr. sq.ft. °Rankine)
Real[2] A (unit = "ft^2");// cross sectional area for 1 ft length
Real[2] q (unit = "BTU/hr");//The heat transferred to water in BTU/hr
parameter Real[7] eta=0:0.2:1.2;
parameter Real[7] theta={1, 0.75, 0.51, 0.31, 0.17, 0.08, 0.01}; // values of dimensionless temperature from figure 7.7 corresponding to eta value taken
Real[7] y;
Real[7] T (unit = "°F");
equation
for i in 1:2 loop
    Re[i]=(V*x[i])/v; 
    // since Reynolds Number is less than 5*10^5, the flow is laminar
    hL[i]=0.664*Pr^(1/3)*Re[i]^0.5*kf/x[i];
    A[i]=x[i]*18/12; 
    q[i]=hL[i]*A[i]*(Tw-T_inf);
end for;

for i in 1:7 loop
y[i]=eta[i]*(v*x[1]/V)^0.5;
T[i]=theta[i]*(Tw-T_inf)+T_inf;
end for;
end Ex7_2;