class Ex7_8
// Estimation of force exerted on the pole
// properties of air at given conditions from appendix table D1
parameter Real rho (unit  = "lbm/ft^3")= 0.0735; // density in lbm/ft^3 
parameter Real v (unit  = "ft^2/s")= 16.88e-5; // viscosity in ft^2/s 
parameter Real V (unit  = "ft/s")=20*5280/3600; // flow velocity in ft/s
parameter Real D (unit  = "ft")=12/12; // diameter of pole in ft
parameter Real L (unit  = "")=30;// length of pole in ft
parameter Real gc (unit  = "ft/sec^2")=32.2;
Real Re_D; // Reynolds Number for flow past the pole
parameter Real Cd_cylinder=1.1; // value of Cd for smooth cylinder from figure 7.22
Real A_cylinder (unit  = "ft^2"); // frontal area of pole
Real Df_cylinder (unit  = "lbf");//The Drag force exerted on only the pole in lbf
parameter Real D_square (unit  = "ft")=2/12; // length of square part of pole
parameter Real L_square (unit  = "ft")=4;
Real Re_square; // Reynolds Number for square part of pole
parameter Real Cd_square=2; // Corresponding value of Cd for square part from figure 7.23
Real A_square (unit  = "ft^2"); // projected frontal area of square part
Real Df_square (unit  = "lbf");//The Drag force exerted on cross piece of the pole in lbf
Real Df_total (unit  = "lbf");//The total drag force on the pole in lbf

equation
Re_D=V*D/v;
A_cylinder=D*L;
Df_cylinder=Cd_cylinder*(1/2)*rho*V^2*A_cylinder/gc;
Re_square=V*D_square/v;
A_square=D_square*L_square;
Df_square=Cd_square*(1/2)*rho*V^2*A_square/gc;
Df_total=Df_cylinder+Df_square;
end Ex7_8;