class Ex8_4
import Modelica.SIunits.*;
// Determination of the variation of average convection coefficient with distance
// properties of air at (65 + 20)/2 = 42.5 degree C =315 K. from appendix table D1
parameter Density rho= 1123; // density in kg/m^3 
parameter SpecificHeatCapacity cp= 1006.7; // specific heat in J/(kg*K) 
parameter KinematicViscosity v= 17.204e-6; // viscosity in m^2/s  
parameter Real Pr =0.703; // Prandtl Number 
parameter ThermalConductivity kf= 0.02738; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a = 0.2446e-4; // diffusivity in m^2/s 
parameter Acceleration g=9.81;//Gravitational acceleration in m/s^2
parameter Length L=5;
parameter Angle theta=45*3.1412/180;//Roof angle in radians
parameter Temperature T_inf=20+273.15; // ambient air temperature in K
parameter Temperature Tw=65+273.15; // roof surface temperature in K
CubicExpansionCoefficient Beta; // volumetric thermal expansion coefficient in per K
Length x;//The Laminar-turbulent  transition length by Vliet equation in m
parameter Length[8] X={0.02, 0.04, 0.05, 0.051, 0.1, 1.0, 3.0, 5.0}; // entering values for length in m
Real[8] Ra; //The Rayleigh's number
CoefficientOfHeatTransfer[8] hc;//The convective coefficient in in W/(sq.m.K) 

equation
Beta=1/(T_inf);
x=((3e5*exp(0.1368*cos(theta))*v*a)/(g*cos(theta)*Beta*(Tw-T_inf)))^(1/3);
for i in 1:8 loop
    if X[i]<=x then
        // Laminar Flow regime exists
        Ra[i]=(g*cos(theta)*Beta*(Tw-T_inf)*X[i]^3)/(v*a);
        hc[i]=(kf/X[i])*(0.68+(0.670*Ra[i]^(1/4))/(1+(0.492/Pr)^(9/16))^(4/9));
    else
        // Turbulent Flow regime exists
        Ra[i]=(g*Beta*(Tw-T_inf)*X[i]^3)/(v*a);
        hc[i]=(0.02738/X[i])*(0.825+0.324*Ra[i]^(1/6))^2;
    end if;
end for;

end Ex8_4;