class Ex8_7
//  Determinion of the convection coefficient about the ice cube
// properties of air at (0 + 70)/2 = 35°F == 495 degree R from appendix table D1
parameter Real rho (unit = "lbm/cu.ft")= 0.0809; // density in lbm/cu.ft 
parameter Real cp (unit = "BTU/(lbm-degree Rankine)")=0.240; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real v (unit = "sq.ft/s")= 13.54e-5; // viscosity in sq.ft/s 
parameter Real kf (unit = "BTU/(hr.ft.degree Rankine) ") = 0.01402 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a (unit = "sq.ft/hr") = 0.685; // diffusivity in sq.ft/hr 
parameter Real Pr = 0.712; // Prandtl Number
parameter Real Tw (unit = "degree F")=0; // temperature of outside surface temperature of oven in degree F
parameter Real T_inf (unit = "degree F")=70; // ambient temperature  in degree F
parameter Real g (unit = "ft/s^2")=32.2;//Gravitational acceleration in ft/s^2
Real Beta (unit = "per degree Rankine"); // volumetric thermal expansion coefficient in per degree Rankine
//  The characteristic length is found by using King Equation
parameter Real Lc (unit = "ft")=1/((1/1)+(1/1.2));//The characteristic length in ft
Real Ra;//The Rayleigh Number
Real hc (unit = "BTU/(hr.sq.ft.degree R)");//The value of convection coefficient in BTU/(hr.sq.ft.degree R)

equation
Beta =1/(T_inf+460);
Ra =(g*Beta*abs(Tw-T_inf)*Lc^3)/(v*a/3600);
hc =(kf/Lc)*0.6*(Ra)^(1/4);
end Ex8_7;