class Ex1_7
  import Modelica.SIunits.*; 
  parameter Area A=1; // Assuming A=1 m^2 for convenience
  parameter CoefficientOfHeatTransfer hc1_avg=(5+25)/2; // Taking average of extreme values for hc [W/m^2.K]
  parameter ThermalResistance Rc1=1/(hc1_avg*A); // Resistance on left side of wall [K/W]
  parameter ThermalConductivity k=(0.38+0.52)/2; // Thermal conductivity of common brick in W/M.k
  parameter Length L=0.1; //Width of the chimney in m
  parameter ThermalResistance Rk=(L/(k*A));// Resistance of construction material, which is assumed to be common brick
  parameter ThermalResistance Rc2=Rc1;
  parameter Temperature T_inf1=1000; // Temperature of exhaust gases in K
  parameter Temperature T_inf2=283; // Temperature of ambient air in K
  Power q; // Heat transferred per unit area
  Temperature T_in;   // Inside wall temperature of the chimney in C
  Temperature T_out;  //Outside wall temperature of the chimney in C
equation
  q=(T_inf1-T_inf2)/(Rc1+Rk+Rc2); 
  T_in=T_inf1-Rc1*q;
  T_out=T_inf2+Rc2*q;
end Ex1_7;