class Ex10_2
import Modelica.SIunits.*;
// Determination of both the heat that the cooling fluid must remove and the condensation rate. 
// properties of water at (100 + 60)/2 = 80°C from appendix table C11
parameter Density rho_f= 947; // density in kg/m^3 
parameter SpecificHeatCapacity cp_1= 4196; // specific heat in J/(kg*K) 
parameter KinematicViscosity v_1= 0.364e-6; // viscosity in m^2/s  
parameter Real Pr_1 =2.22; // Prandtl Number 
parameter ThermalConductivity kf= 0.668; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a_1 =1.636e-7; // diffusivity in m^2/s 
parameter SpecificVolume Vv=1.9364; // specific volume in m^3/kg
Density rho_v; // vapor density;
parameter Acceleration g=9.81;//Gravitational acceleration in m/s^2
parameter SpecificEnergy hfg=2257060; 
parameter Temperature Tg=100+273.15;
parameter Temperature Tw=60+273.15;
parameter Length L=1;
// specifications of 1 nominal schedule 40 pipe from appendix F1
parameter Length OD=0.03340;// Outer dia of 1 nominal schedule 40 pipe
CoefficientOfHeatTransfer hD;//The average heat transfer coefficient in W/(sq.m.K)
HeatFlowRate q;//The heat flow rate in W
MassFlowRate mf;//nThe rate at which steam condenses in kg/s 

equation
rho_v=1/Vv;
hD=0.782*((g*rho_f*(1-(rho_v/rho_f))*(kf^3)*hfg)/(v_1*OD*(Tg-Tw)))^(1/4);
q=hD*3.1412*OD*L*(Tg-Tw);
mf=q/hfg;//Error in the textbook
end Ex10_2;