class Ex11_2
import Modelica.SIunits.*;
// solid angle is calculate using the equation dw=dA*cos(Beta)/r^2
// The angle Beta is 0 because the surface normal of dA2 is directed at dA1
parameter Area dA2=0.02*0.02;//Area of diff area dA2 in m^2
parameter Angle Beta=0;//the angle between the surface normal of a dA2 and the line connecting dA1 and dA2
parameter Length r=1;//plane radius in metre
SolidAngle dw2_1;//The solid angle subtended by area dA2 with respect to dA1 in sr
parameter Area dA1=dA2;//Area of diff area. dA1 in m^2
parameter Angle theta=3.1412*30/180;//Angle b/w dA1 and dA2 in rad
parameter Real I_theta (unit = "W/(m^2.sr)")=1000;// The intensity of radiation leaving dA1 in any direction is 1 000 W/(m^2.sr)
Power dq1_2;//The rate at which radiation emitted by dA1 is intercepted by dA2 in W
HeatFlux dQ1_2;//The irradiation associated with dA2 in W/sq.m

equation
dw2_1=dA2*cos(Beta)/r^2;
dq1_2=I_theta*dA1*cos(theta)*dw2_1;
dQ1_2=dq1_2/dA2;
end Ex11_2;