class Ex11_6
import Modelica.SIunits.*;
// (a) Calculation of the rate at which the sun’s radiant energy is transmitted through the glass windshield. The interior of the car is considered to be a black body that radiates at 100°F. (b) Calculation of the rate at which radiant energy from the car interior is transmitted through the glass windshield. 
parameter Length lambda1=300e-9; // lower limit of wavelength
parameter Length lambda2=380e-9; // upper limit of wavelength
parameter Temperature T=5800;//Temperature on the sun's surface in K.
Real lambda1_T (unit = "m.K");// Lower limit of Wavelength-Temperature Products in m.K
Real lambda2_T (unit = "m.K");// Upper limit of Wavelength-Temperature Products in m.K
parameter Real I1=0.101; //Fraction of Total Radiation Emitted for lower Wavelength-Temperature Product from Table 11.1
parameter Real I2=0.0334; //Fraction of Total Radiation Emitted for upper Wavelength-Temperature Product from Table 11.1
Real dI;
Real t=dI*0.68; // transmissivity
parameter HeatFlux q=1100; // radiation received by car in W/sq.m
HeatFlux q_in; // energy transmitted from the sun through the glass in  W/sq.m
parameter Temperature Tb=311; // temperature of black body source in K
Real lambda1_Tb;// Lower limit of Wavelength-Temperature Products in m.K
Real lambda2_Tb;// Upper limit of Wavelength-Temperature Products in m.K
parameter Real dI_b=0; // Table 11.1 gives negligibly small values of the corresponding integrals.
Real t_b; // transmissivity
HeatFlux q_out;//the rate at which radiant energy from the car interior is transmitted through the glass windshield in W/sq.m

equation
lambda1_T=lambda1*T;
lambda2_T=lambda2*T;
dI=abs(I2-I1);
q_in=t*q;
lambda1_Tb=lambda1*Tb;
lambda2_Tb=lambda2*Tb;
t_b=dI_b*0.68;
q_out=t_b*q;
end Ex11_6;