class Ex12_6
//  Determination of the heat that must be supplied to each of the isothermal surfaces, and also the temperature of the insulated surface. 
// we can apply the equations as follows
// q1=sigma*A1*[(T1^4-T2^4)F12+(T1^4-T3^4)F13]..... (1)
// q2=sigma*A2*[(T2^4-T1^4)F21+(T2^4-T3^4)F23]..... (2)
// q3=sigma*A3*[(T3^4-T1^4)F31+(T3^4-T2^4)F32]..... (3)
// given data:
parameter Real T1 (unit = "°R")=1000;//Temperature of Area A1
parameter Real T3 (unit = "°R")=500;//Temperature of Area A2
parameter Real q2 (unit = "BTU/(hr.sq.ft)")=0;//The heat flux through area A2 in BTU/(hr.sq.ft)
parameter Real F12=1/2;//view factor between surfaces 1 and 2.
parameter Real F13=1/2;//view factor between surfaces 1 and 3.
parameter Real F21=1/2;//view factor between surfaces 2 and 1.
parameter Real F23=1/2;//view factor between surfaces 2 and 3.
parameter Real F31=1/2;//view factor between surfaces 3 and 1.
parameter Real F32=1/2;//view factor between surfaces 3 and 2.
Real T2 (unit = "°R"); // using equation (2)
parameter Real sigma (unit = "BTU hr^−1 ft^−2 °R^−4")=0.1714e-8; // Stefan-Boltzmann constant
Real q1_A1 (unit = "BTU/(hr.sq.ft)"); // The heat flux through area A1 in BTU/(hr.sq.ft)
Real q3_A3 (unit = "BTU/(hr.sq.ft)"); // The heat flux through area A3 in BTU/(hr.sq.ft)

equation
T2=((T1^4+T3^4)/2)^(1/4);
q1_A1=sigma*((T1^4-T2^4)*F12+(T1^4-T3^4)*F13);
q3_A3=sigma*((T3^4-T1^4)*F31+(T3^4-T2^4)*F32);
end Ex12_6;