class Ex12_7
import Modelica.SIunits.*;
// Determination of the heat lost by the oven through its top surface. 
// all energy leaving A1 is intercepted by A2 and vice versa
parameter Real F12=1;//view factor between surfaces 1 and 2.
parameter Real F21=1;//view factor between surfaces 2 and 1.
parameter Real F11=0;//view factor between surfaces 1 and 1.
parameter Real F22=0;//view factor between surfaces 2 and 2.
parameter Real emissivity1=0.94; // for oxidized steel from appendix table E1
parameter Real emissivity2=0.94;  // for oxidized steel from appendix table E1
parameter Temperature T1=533;//Temperature of Surface 1 in K
parameter Temperature T2=323;//Temperature of Surface 2 in K
parameter Real sigma (unit = "W/m^2.K^4")=5.67e-8; // Stefan-Boltzmann constant
HeatFlux q1;//The heat lost through bottom surface in W/sq.m
HeatFlux q2;//The heat lost through top surface in W/sq.m

equation
q1=(sigma*(T1^4-T2^4))/((1/emissivity1)+(1/emissivity2)-1);
q2=-q1;
end Ex12_7;