class Ex2_10
// determination of optimum fin length and heat transferred by fin
parameter Real k (unit = "BTU/(hr.ft.degree Rankine)")=8.32; // thermal conductivity of Type 304 stainless steel in BTU/(hr.ft.degree Rankine)from appendix table B2
parameter Real hc (unit = "BTU/(hr.ft^2. degree Rankine)")=400; // the convective heat transfer coefficient given in BTU/(hr.ft^2. degree Rankine)
parameter Real delta_opt (unit = "feet")=0.55/(12*2);
// determination of dimension of one fin using the equation delta_opt=0.583*hc*Lc^2/k
Real Lc (unit = "feet");//The optimum length in feet
Real A (unit = "ft^2");
// determination of parameter for finding out efficiency from graph
Real param; //The parameter value for finding the efficiency
parameter Real efficiency=0.6; //Efficiency found from the graph
parameter Real  W (unit = "feet") =1/(2*12);// width in ft
parameter Real T_w (unit = "°F")=190; // wall temperature in degree fahrenheit
parameter Real T_inf (unit = "°F")=58; // ambient temperature in degree fahrenheit
parameter Real L (unit = "feet")=1; // length in ft
parameter Real delta (unit = "feet")=W/2; 
Real q_ac (unit = "BTU/hr");//The actual heat transferred in  BTU/hr
equation
Lc=sqrt(delta_opt*k/(0.583*hc));
A=Lc*delta_opt;
param=Lc^1.5*sqrt(hc/(k*A));
q_ac=efficiency*hc*2*W*sqrt(L^2+delta^2)*(T_w-T_inf); //Error in the textbook
end Ex2_10;