class Ex2_3
parameter Real k1 (unit = "BTU/(hr.ft.°Rankine)")=24.8; // thermal conductivity of 1C steel in BTU/(hr.ft.degree Rankine)from appendix B2 
parameter Real k2 (unit = "BTU/(hr.ft.°Rankine)")=0.02; // thermal conductivity of styrofoam steel in BTU/(hr.ft.degree Rankine)
parameter Real k3 (unit = "BTU/(hr.ft.°Rankine)")=0.09; // thermal conductivity of fibreglass in BTU/(hr.ft.degree Rankine)
parameter Real hc1 (unit = "BTU/(hr.ft^2.°Rankine)")=0.79; // convection coefficient between the air and the vertical steel wall in BTU/(hr.ft^2.°Rankine)
parameter Real hc2 (unit = "BTU/(hr.ft^2.°Rankine)")=150; // the convection coefficient between the ice water and the fiberglass
parameter Real A (unit = "ft^2")=1; // Calculation being done per ft^2
parameter Real dx1 (unit = "ft")=0.04/12; // thickness of steel in ft
parameter Real dx2 (unit = "ft")=0.75/12; // thickness of styrofoam in ft
parameter Real dx3 (unit = "ft")=0.25/12; // thickness of fiberglass in ft
parameter Real T_inf1 (unit = "°F")=90;// temperature of air in degree F
parameter Real T_inf2 (unit = "°F")=32; // temperature of mixture of ice and water in degree F
Real Rc1 (unit = "°F·h/BTU(IT)"); // Resistance from air to sheet metal
Real Rk1 (unit = "°F·h/BTU(IT)"); // Resistance of steel layer
Real Rk2 (unit = "°F·h/BTU(IT)"); // Resistance of styrofoam layer
Real Rk3 (unit = "°F·h/BTU(IT)"); // Resistance of fiberglass layer
Real Rc2 (unit = "°F·h/BTU(IT)"); // Resistance from ice water to fiberglass
Real U (unit = "BTU/(hr.ft^2.degree Rankine)");   // overall heat transfer coefficient in BTU/(hr.ft^2.degree Rankine)
Real q (unit = "BTU/hr");   // Heat transfer in BTU
equation
Rc1=1/(hc1*A); 
Rk1=dx1/(k1*A);
Rk2=dx2/(k2*A); 
Rk3=dx3/(k3*A);
Rc2=1/(hc2*A);
U=1/(Rc1+Rk1+Rk2+Rk3+Rc2); 
q=U*A*(T_inf1-T_inf2);
end Ex2_3;