class Ex2_4
// dimensions of steel pipes in cm from appendix table F1
import Modelica.SIunits.*; 
parameter Length D2=0.3239;
parameter Length D1=0.2953;
parameter Temperature T1=40 + 273.15;
parameter Temperature T2=38 + 273.15;
parameter ThermalConductivity k = 14.4; //Conductivity of 304 stainless steel from appendix B2
Power Qr; //heat transfer through the pipe wall per unit length of pipe
equation
Qr =(2*3.14*k)*(T1-T2)/log(D2/D1);
end Ex2_4;