class Ex2_6
// Determination of the overall heat transfer coefficient
parameter Real k12 (unit = "BTU/(hr.ft.degree Rankine)")=24.8; // thermal conductivity of 1C steel in BTU/(hr.ft.degree Rankine)from appendix table B2 
parameter Real k23 (unit = "BTU/(hr.ft.degree Rankine)")=0.023; // // thermal conductivity of glass wool insulation in BTU/(hr.ft.degree Rankine)from appendix table B3 
// Specifications of 6 nominal, schedule 40 pipe (no schedule was specified, so the standard is assumed) from appendix table F1 are as follows
parameter Real D2 (unit = "ft")=6.625/12; // outer diameter in ft
parameter Real D1 (unit = "ft")=0.5054; // inner diameter in ft
parameter Real t (unit = "ft")=2/12; // wall thickness of insulation in ft
parameter Real D3 (unit = "ft")=D2+t;
parameter Real hc1 (unit = "BTU/(hr. sq.ft.degree Rankine)")=12; // convection coefficient between the air and the pipe wall in BTU/(hr. sq.ft.degree Rankine).
parameter Real hc2 (unit = "BTU/(hr. sq.ft.degree Rankine)")=1.5; // convection coefficient between the glass wool and the ambient air in  BTU/(hr. sq.ft.degree Rankine).
Real U (unit = "BTU/(hr.ft^2.degree Rankine)");   // overall heat transfer coefficient in BTU/(hr.ft^2.degree Rankine)
equation
U=1/((1/hc1)+(D1*log(D2/D1)/k12)+(D1*log(D3/D2)/k23)+(D1/(hc2*D3)));
end Ex2_6;