class Ex3_2
import Modelica.Math.*;
parameter Real OD (unit = "ft")=10.74/12; // diameter in ft
parameter Real R (unit = "ft")=OD/2;//Radius in ft
parameter Real T1 (unit = "°F")=140;//Outer Temp
parameter Real T2 (unit = "°F")=65;//Inner Temp
parameter Real k (unit = "BTU/(hr-ft. degree R)")=0.072; // thermal conductivity in BTU/(hr-ft. degree R)
parameter Real d (unit = "ft")=18/12; // distance from centre-line
Real S_L (unit = "ft^-1");//Shape factor per unit length
Real q_L (unit = "BTU/(hr.ft)");//The heat transferred from the buried pipe per unit length in  BTU/(hr.ft)
equation
 S_L=(2*3.1412)/(acosh(d/R));
 q_L=k*S_L*(T1-T2);
end Ex3_2;