class Ex3_3
import Modelica.SIunits.*;
parameter ThermalConductivity k = 1.07; // thermal conductivity of silica brick from appendix table B3 in W/(m.K)
// Calculation of total shape factor
// From figure 3.12, for component A
parameter Real S1_A=0.138*0.138/0.006;
parameter Real nA=2;
Real St_A; // Total shape factor of component A
// For component B
parameter Real S1_B=0.138*0.188/0.006;
parameter Real nB=4;
Real St_B; // Total shape factor of component B
// For component C
parameter Real S3_C=0.15*0.006;
parameter Real nC=8;
Real St_C; // Total shape factor of component C
// For component D
parameter Real S2_D=0.54*0.188;
parameter Real nD=4;
Real St_D; // Total shape factor of component D
// For component E
parameter Real S2_E=0.138*0.54;
parameter Real nE=8;
Real St_E; // Total shape factor of component E
Real S; //The Total shape factor
parameter Temperature T1=550;
parameter Temperature T2=30;
HeatFlowRate q;//The heat transferred through the walls of the furnace
// Neglecting the effects of the edges and corners, the shape factor for all walls is found as 
Real S_1;//The shape factor for all walls, neglecting the effects of the edges and corners
HeatFlowRate q_1;//The heat transferred, neglecting the effects of the edges and corners in W.
Real Error; //Error percentage
equation
St_A=nA*S1_A;
St_B=nB*S1_B; 
St_C=nC*S3_C;
St_D=nD*S2_D;
St_E=nE*S2_E;
S=St_A+St_B+St_C+St_D+St_E;
q=k*S*(T1-T2);
S_1=St_A+St_B;
q_1=k*S_1*(T1-T2);
Error=(q-q_1)/q*100;
end Ex3_3;