class Ex4_2
import Modelica.SIunits.*;
parameter ThermalConductivity k=236; // thermal conductivity in W/(m.K)
parameter SpecificHeatCapacity Cp=896;// specific heat in J/(kg.K)
parameter RelativeDensity sp_gr=2.702; // specific gravity
parameter Density density=2702; // density in kg/cu.m
parameter Length D=0.05; // Diameter in m
parameter Length L=0.60; // length in m
parameter Real hc=550; // unit surface conductance between the metal and the bath in W/(K.sq.m)
Volume Vs; // Volume of cylinder in cu.m
Area As; // surface area of cylinder in sq.m
Real Bi; // Biot Number
Temperature T_i=50; // initial temperature in degree celsius
Temperature T_inf=2; // temperature of ice water bath in degree celsius
Time t=60; // time=1 minute=60 s
Temperature T;//The temperature of aluminium
Heat Q; //The cumulative heat transferred in J
equation
Vs=(3.14*D^2*L)/4;
As=(2*3.14*D^2/4)+(3.14*D*L);
Bi=(hc*Vs)/(k*As); 
T=T_inf+(T_i-T_inf)*exp(-(hc*As)/(density*Vs*Cp)*t);
Q=density*Vs*Cp*(T_inf-T_i)*(1-exp(-(hc*As)/(density*Vs*Cp)*t));//Error in the textbook calculation
end Ex4_2;