class Ex4_6
import Modelica.SIunits.*;
parameter ThermalConductivity k_al=236;//Thermal Conductivity of Aluminium
parameter Density p_al=2.7*1000;//Density  of Aluminium
parameter SpecificHeatCapacity c_al=896;// Specific Heat Capacity of Aluminium
// properties of oak from appendix table B3
parameter ThermalConductivity k_oak=0.19;//Thermal Conductivity of oak
parameter Density p_oak=0.705*1000;//Density  of oak
parameter SpecificHeatCapacity c_oak=2390;// Specific Heat Capacity of oak
Real sqrt_kpc_al;//The square root of kpc product of aluminium 
parameter Real kpc_R=4;//KPC of skin
parameter Temperature T_Li=20+273.15;//Laboratory Temperature
parameter Temperature T_Ri=37.3+273.15;//Body temperature
Temperature T_al;//Temperature of Aluminium
Real sqrt_kpc_oak;//The square root of kpc product of oak 
Temperature T_oak;//Temperature of oak
equation
sqrt_kpc_al=sqrt(k_al*p_al*c_al);
T_al=(T_Li*(sqrt_kpc_al)+T_Ri*sqrt(kpc_R))/(sqrt_kpc_al+sqrt(kpc_R));
sqrt_kpc_oak=sqrt(k_oak*p_oak*c_oak);
T_oak=(T_Li*(sqrt_kpc_oak)+T_Ri*sqrt(kpc_R))/(sqrt_kpc_oak+sqrt(kpc_R));
//if (T_al>T_oak) then
   //  The aluminium will feel warmer.
//elseif  (T_al<T_oak) then
  //  The oak will feel warmer.
//else
 //   Both will be felt equally warm.

end Ex4_6;