class Ex6_3
import Modelica.SIunits.*;
// properties of milk 
parameter ThermalConductivity kf=0.6; // thermal conductivity in W/(m-K)
parameter SpecificHeatCapacity cp=3.85*1000; // specific heat in J/(kg*K)
parameter Density rho=1030; // density in kg/m^3
parameter DynamicViscosity mu=2.12e3; // viscosity in N s/m^2
// specifications of 1/2 standard type K tubing from appendix table F2
parameter Length OD=1.588/100; // outer diameter in m
parameter Length ID=1.340/100; // inner diameter in m
parameter Area A=1.410e-4; // cross sectional area in m^2
parameter Velocity V=0.1;//Average flow velocity
// determination of flow regime
Real Re;//Reynolds Number
// The flow being laminar, the hydrodynamic entry length is calculated as follows
Length ze;//The hydrodynamic entry length in m
parameter Temperature Tbo=71.7+273.15; // final temperature in kelvin
parameter Temperature Tbi=20+273.15; // initial temperature in kelvin
parameter Length L=6; // heating length in m
HeatFlux qw;//The heat flux in W/sq.m
Power q;//The power required in W
Real Pr; // Prandtl Number
Length zf=0.05*ID*Re*Pr;//The length required for flow to be thermally developed in m
// calculations of wall temperature of the tube
parameter Real[5] reciprocal_Gz={0.002, 0.004, 0.01, 0.04, 0.05};// values of 1/Gz taken
parameter Real[5] Nu={12, 10, 7.5, 5.2, 4.5}; //Enter the corresponding value of Nusselts Number from figure 6.8
Real[5] z;
Real[5] h;
Temperature[5] Tbz;//Body Temperature 
Temperature[5] Twz;//Wall Temperature 
algorithm
Re:=rho*V*ID/(mu);
ze:=0.05*ID*Re;
qw:=rho*V*ID*cp*(Tbo-Tbi)/(4*L);
q:=qw*3.1412*ID*L;
Pr:=(cp*mu)/kf;
for i in 1:5 loop
    z[i]:=ID*Re*Pr*reciprocal_Gz[i];
    h[i]:=kf*Nu[i]/ID;
    Tbz[i]:=Tbi+(8.617*z[i]);
    Twz[i]:=Tbz[i]+(11447/h[i]);
end for;

end Ex6_3;