class Ex7_10
// Calculation of the pressure drop for the air passing over the tubes and the heat transferred to the air.
// properties of air at  70 + 460 = 530 ° R = 540 ° R from appendix table D1
parameter Real rho (unit = "lbm/cu.ft")= 0.0735; // density in lbm/cu.ft 
parameter Real cp (unit = "BTU/(lbm-°R)")=0.240; // specific heat BTU/(lbm-°R) 
parameter Real v (unit = "sq.ft/s")= 16.88e-5; // viscosity in sq.ft/s 
parameter Real kf (unit = "BTU/(hr.ft.°R)") = 0.01516 ; // thermal conductivity in BTU/(hr.ft.°R) 
parameter Real a (unit = "sq.ft/hr") = 0.859; // diffusivity in sq.ft/hr 
parameter Real Pr = 0.708; // Prandtl Number
// specifications of 3/4 standard type K copper tubing from appendix table F2
parameter Real OD (unit = "ft")=0.875/12; // outer diameter in ft
parameter Real ID (unit = "ft")=0.06208; // inner diameter in ft
parameter Real A (unit = "ft^2")=0.003027; // cross sectional area in sq.ft
parameter Real L (unit = "ft")=2;
parameter Real sL (unit = "ft")=1.5/12;
parameter Real sT (unit = "ft")=1.3/12;
parameter Real V_inf (unit = "ft/s")=12; // velocity of air in ft/s
Real V1 (unit = "ft/s"); // velocity at area A1 in ft/s
Real sD (unit = "feet"); // diagonal pitch in feet
Real V2 (unit = "ft/s");//Velocity at area A2 in ft/s
Real Vmax (unit = "ft/s");//Maximum velocity
Real Re_D; // Reynolds Number
parameter Real sT_OD=1.3/0.875;//Parameters
parameter Real sT_sL=1.3/1.5;  //Parameters
parameter Real f1=0.35; //value of f1 for above values of sT/Do and Re
parameter Real f2=1.05; //Corresponding value of f2 for above values of sT/sL and Re
parameter Real gc (unit = "ft/sec^2")=32.2;
parameter Real N=7;
Real dP (unit = "lbf/ft^2");//The pressure drop in lbf/ft^2 
Real sL_Do;
parameter Real C1=0.438; //value of C1 for above values of sT/Do and sL/Do
parameter Real C2=0.97; //value of C2 for above values of sT/Do and sL/Do
parameter Real m (unit = "")=0.565; //value of m for above values of sT/Do and sL/Do
Real hc (unit = "BTU/(hr.sq.ft.°R)"); // The convection coefficient in BTU/(hr.sq.ft.°R)
Real As (unit = "sq.ft"); // outside surface area of 70 tubes in sq.ft
parameter Real Tw (unit = "°F")=200; // outside surface temeperature in °F
parameter Real T_inf (unit = "°F")=70; // air temperature in °F
Real q (unit = "BTU/hr");// heat transferred in BTU/hr

equation
V1=(sT*V_inf)/(sT-OD);
sD=((sL)^2+(sT/2)^2)^0.5;
V2=(sT*V_inf)/(2*(sD-OD));
if V1>V2 then
    Vmax=V1;
else 
    Vmax=V2;
end if;
Re_D=Vmax*OD/v; 
dP=N*f1*f2*(rho*Vmax^2/(2*gc));
sL_Do=sL/OD;
hc=kf*1.13*C1*C2*(Re_D)^m*(Pr)^(1/3)/OD;
As=70*3.1412*OD*L; 
q=hc*As*(Tw-T_inf);
end Ex7_10;