class Ex7_3
import Modelica.SIunits.*;
// Determination of  the average  convection  coefficient and the total drag force exerted  on the plate.
// properties of air at (300 + 400)/2 = 350 K from appendix table D1
parameter Density rho= 0.998; // density in kg/cu.m
parameter SpecificHeatCapacity cp= 1009; // specific heat in J/(kg*K) 
parameter KinematicViscosity v= 20.76e-6; // viscosity in sq.m/s  
parameter Real Pr = 0.697; // Prandtl Number 
parameter Density k= 0.03003; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a = 0.2983e-4; // diffusivity in sq.m/s 
parameter Length L=1; // Length of plate in m
parameter Velocity V=5; // velocity of air in m/s
parameter Length b=0.5; // width in m
Real Re; // Reynolds number at plate end
// Since the flow is laminar at plate end, The average convection coefficient is calculated with Equation Nu=h*L/k= 0.664 Re^(1/2)Pr^(1/3)
CoefficientOfHeatTransfer h; // The average convection coefficient in W/(sq.m.K)
Force Df; // drag force in N
CoefficientOfHeatTransfer hx; // local convective coefficient
Length delta; // The boundary-layer thickness at plate end
Length delta_t;

equation
Re=V*L/v;
h=k*0.664*Re^(1/2)*Pr^(1/3)/L;
Df=0.664*V*rho*v*b*(Re)^0.5;
hx=(1/2)*h;
delta=5*L/(Re)^0.5;
delta_t=delta/(Pr)^(1/3);
end Ex7_3;