class Ex8_6
import Modelica.SIunits.*;
// determination of heat lost from the insulation by convection
// properties of air at (50 + 5)/2 = 27.5 degree C = 300 K from appendix table D1
parameter Density rho= 1.177; // density in kg/cu.m
parameter SpecificHeatCapacity cp= 1005.7; // specific heat in J/(kg*K) 
parameter KinematicViscosity v= 15.68e-6; // viscosity in sq.m/s  
parameter Real Pr =0.708; // Prandtl Number 
parameter ThermalConductivity kf= 0.02624; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a = 0.22160e-4; // diffusivity in sq.m/s 
parameter Acceleration g=9.81;//Gravitational acceleration in m/s^2
parameter Length L=4; // length in m
parameter Length D=15/100; // diameter in m
parameter Temperature T_inf=5+273.15; // ambient air temperature in K
parameter Temperature Tw=50+273.15; // outside surface temperature in K
CubicExpansionCoefficient Beta; // volumetric thermal expansion coefficient in per K
Real Ra;//The Rayleigh's number
// for horizontal pipe, the convective coefficient is determined as follows
CoefficientOfHeatTransfer hc_h;//The convection coefficient for horizontal length in W/(sq.m.K)
Area As;//Area of the horizontal pipe
Power q_hor;//The heat transferred from the horizontal length of 4 m in W
// for vertical pipe, the convective coefficient is determined as follows
CoefficientOfHeatTransfer hc_v;//The convection coefficient for vertical length in W/(sq.m.K)
Power q_ver;//The heat transferred from the vertical length of 4 m in W
Power q;//The total heat lost from the pipe in W

equation
Beta=1/(T_inf);
Ra=(g*Beta*(Tw-T_inf)*D^3)/(v*a);
hc_h=(kf/D)*(0.60+(0.387*Ra^(1/6))/(1+(0.559/Pr)^(9/16))^(8/27))^2;
As=3.1412*D*L;
q_hor=hc_h*As*(Tw-T_inf);
hc_v=(kf/D)*0.6*(Ra*(D/L))^(1/4);
q_ver=hc_v*As*(Tw-T_inf);
q=q_ver+q_hor;
end Ex8_6;