class Ex9_4
import Modelica.SIunits.*;
// Determination of (a) no. of exchangers required, (b)  the overall  coefficient of (all) the exchanger(s), and (c) the pressure drop for each stream. 
// assuming counterflow arrangement
// properties of air at 323 K. from appendix table D1
parameter Density rho_1= 1.088; // density in kg/m^3 
parameter SpecificHeatCapacity cp_1= 1007; // specific heat in J/(kg*K) 
parameter KinematicViscosity v_1= 18.2e-6; // viscosity in m^2/s  
parameter Real Pr_1 =0.703; // Prandtl Number 
parameter ThermalConductivity kf_1= 0.02814; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a_1 = 0.26e-4; // diffusivity in m^2/s 
parameter MassFlowRate m_1=100/3600; // mass flow rate in kg/hr
// temperatures in K
parameter Temperature t1_air=20+273;//Air temp. in K
parameter Temperature t2_air=80+273;//Air temp. in K
// properties of carbon dioxide at [600 + (20 + 273)]/2 = 480 = 500 K. from appendix table D2
parameter Density rho_2= 1.0732; // density in kg/m^3 
parameter SpecificHeatCapacity cp_2= 1013; // specific heat in J/(kg*K) 
parameter KinematicViscosity v_2= 21.67e-6; // viscosity in m^2/s  
parameter Real Pr_2 =0.702; // Prandtl Number 
parameter ThermalConductivity kf_2= 0.03352; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a_2 = 0.3084e-4; // diffusivity in m^2/s 
parameter MassFlowRate m_2=90/3600; // mass flow rate in kg/hr
// temperatures in K
parameter Temperature T1_CO2=600; 
// specifications of seamless copper tubing from appendix table F2
parameter Length ID_a=0.098;//Inner dia. of annulus in m.
parameter Length ID_p=0.07384;//Inner dia. of inner pipe in m.
parameter Length OD_p=0.07938;//Outer dia. of inner pipe
// Flow Areas
Area A_p;//The area of annulus in sq.m
Area A_a;//The area of inner pipe in sq.m

// Heat Balance 
Power q_air;//The heat transferred in W
Temperature T2_CO2;//he low temperature of carbon dioxide in K
// Log-Mean Temperature Difference
Temperature LMTD_counter;//The LMTD for counter flow configuration in K
// Annulus Equivalent Diameters
Length D_h;//The Annulus Equivalent Diameter for friction in m",D_h
Length D_e;//The Annulus Equivalent Diameter for heat transfer in m
// Reynolds Numbers 
Real Re_1;//The Reynolds Number for air 
Real Re_2;//The Reynolds Number for carbon dioxide
// Nusselt numbers
Real Nu_1;//The Nusselt number for air 
Real Nu_2;//The Nusselt number for carbon dioxide
// Convection Coefficients 
CoefficientOfHeatTransfer h_1i;//The convective coefficient for air based on inner diameter in W/(sq.m.K)
CoefficientOfHeatTransfer h_1o;//The convective coefficient for air based on outer diameter in W/(sq.m.K)
CoefficientOfHeatTransfer h_2;//The convective coefficient for carbon dioxide in W/(sq.m.K)
// Fouling Factors in (m^2.K)/W
parameter ThermalInsulance Rd_air=0.0004;
parameter ThermalInsulance Rd_CO2=0.002;
// exchanger coefficients
CoefficientOfHeatTransfer Uo;
CoefficientOfHeatTransfer U;//The overall exchanger coefficient inf W/(sq.m.K)
// area required
Area A;//The area required in sq.m
// surface area of one exchanger is A=3.1412*OD*L, so
Length L; // length of each exchanger in m
parameter Length L_available=2; // available exchanger length in m
Real N; // no. of exchangers
//friction factors
parameter Real fp=0.0245; //friction factor for air fom figure 6.14 corresponding to Reynolds Number calculated above
parameter Real fa=0.033; //friction factor for carbon dioxide fom figure 6.14 corresponding to Reynolds Number calculated above
// Velocities
Velocity V_air;//The velocity of air in m/s
Velocity V_CO2;//The velocity of carbon dioxide in m/s
// pressure drops
Pressure dP_p;//The pressure drop for tube side in Pa
Pressure dP_a;//The pressure drop for shell side in Pa

equation
A_p=3.1412*(ID_p^2)/4;
A_a=3.1412*((ID_a)^2-(OD_p)^2)/4;
q_air=(m_1)*(cp_1)*(t2_air-t1_air);
T2_CO2=T1_CO2-(q_air/(m_2*cp_2));
LMTD_counter=((T1_CO2-t2_air)-(T2_CO2-t1_air))/(log((T1_CO2-t2_air)/(T2_CO2-t1_air)))+273.15;
D_h=ID_a-OD_p;
D_e=(ID_a^2-OD_p^2)/(OD_p);
Re_1=(m_1)*(ID_p)/(v_1*rho_1*A_p);
Re_2=(m_2)*(D_e)/(v_2*rho_2*A_a);
Nu_1=0.023*(Re_1)^(4/5)*(Pr_1)^0.3;
Nu_2=0.023*(Re_2)^(4/5)*(Pr_2)^0.4;
h_1i=Nu_1*kf_1/ID_p;
h_1o=h_1i*ID_p/OD_p;
h_2=Nu_2*kf_2/D_e;
Uo=1/((1/h_1o)+(1/h_2));
U=1/((1/Uo)+Rd_air+Rd_CO2);
A=q_air/(U*LMTD_counter);
L=(A/(3.1412*OD_p));
N=L_available/L;
V_air=(m_1)/(rho_1*A_p);
V_CO2=(m_2)/(rho_2*A_a);
dP_p=(fp*L_available*rho_1*V_air^2)/(ID_p*2);
dP_a=((rho_2*V_CO2^2)/2)*((fa*L_available/D_h)+1);
end Ex9_4;