class Ex9_5
//  Determination of the outlet temperature of the distilled  water and the pressure drop for each stream. 
// properties of (distilled) water at 104°F from appendix table CII
parameter Real rho_1 (unit = "lbm/ft^3")= 0.994*62.4; // density in lbm/ft^3 
parameter Real cp_1 (unit = "BTU/(lbm-degree Rankine) ")=0.998; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real v_1 (unit = "ft^2/s")= 0.708e-5; // viscosity in ft^2/s 
parameter Real kf_1 (unit = "BTU/(hr.ft.degree Rankine") = 0.363 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a_1 (unit = "ft^2/hr") = 5.86e-3; // diffusivity in ft^2/hr 
parameter Real Pr_1 = 4.34; // Prandtl Number 
parameter Real m_1 (unit = "lbm/hr")=170000; // mass flow rate in lbm/hr
parameter Real T1 (unit = "degree F")=110; // temperature in degree F
// properties of (raw) water at 68°F from Appendix Table C11
parameter Real rho_2 (unit = "lbm/ft^3")= 62.4; // density in lbm/ft^3 
parameter Real cp_2 (unit = "BTU/(lbm-degree Rankine)")=0.9988; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real v_2 (unit = "ft^2/s")= 1.083e-5; // viscosity in ft^2/s 
parameter Real kf_2 (unit = "BTU/(hr.ft.degree Rankine)") = 0.345 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a_2 (unit = "ft^2/hr") = 5.54e-3; // diffusivity in ft^2/hr 
parameter Real Pr_2 = 7.02; // Prandtl Number 
parameter Real m_2 (unit = "lbm/hr")=150000; // mass flow rate in lbm/hr
parameter Real t1 (unit = "degree F")=65; // temperature in degree F
// specifications of 3/4-in-OD, 18-BWG tubes, from table 9.2
parameter Real OD (unit = "ft")=3/(4*12);//Outer dia. of the 3/4-in-OD, 18-BWG tube in ft
parameter Real ID (unit = "ft")=0.652/12;//Inner dia.  of the 3/4-in-OD, 18-BWG tube in ft
parameter Real OD_p (unit = "ft")=1.375/12;//Outer dia. of the pipe in feet
parameter Real Nt =224; // from table 9.3
parameter Real Np =2; // no. of tube passes
// Shell dimensions and other miscellaneous data
parameter Real Ds (unit = "ft")=17.25/12;//Dia. of shell in ft
parameter Real Nb=15; // no. of baffles
parameter Real B (unit = "ft")=1;//Baffle spacing in feet
parameter Real sT (unit = "ft")=15/(16*12);//Triangular pitch of the tubes
parameter Real C (unit = "ft")=sT-OD;// in feet
// flow areas
Real At (unit = "feet^2");//Flow Area of the tube in feet^2
Real As (unit = "feet^2");//Flow Area of the shell in feet^2

// Shell Equivalent Diameter 
Real De (unit = "ft");//The shell equivalent diameter in ft
// Reynolds Numbers 
Real Re_s;//The Reynolds Number for raw water
Real Re_t;//The Reynolds Number for distilled water
// Nusselt numbers
Real Nu_t;//The Nusselt number for raw water
Real Nu_s;//The Nusselt number for distilled water
Real h_ti (unit = "BTU/(hr.sq.ft.degree R");//The convective coefficient for raw water based on inner diameter in BTU/(hr.sq.ft.degree R
Real h_to (unit = "BTU/(hr.sq.ft.degree R");//The convective coefficient for raw water based on outer diameter in BTU/(hr.sq.ft.degree R
Real h_s (unit = "BTU/(hr.sq.ft.degree R");//The convective coefficient for distilled water in BTU/(hr.sq.ft.degree R

// Exchanger Coefficient 
Real Uo (unit = "BTU/(hr.sq.ft.degree R)");//The overall exchanger coefficient in BTU/(hr.sq.ft.degree R)
Real R;//The ratio
parameter Real L (unit = "feet")=16;//Exchanger length in feet
Real Ao (unit = "sq. ft");//Exchanger area in sq. ft
Real UoAo_mccp;//(UoAo)/(McCpc)
Real S =0.58; //value of S from fig. 9.13 Ten Broeck graph corresponding to the value of (UoAo)/(McCpc)
Real t2 (unit = "degree F");//t2 for raw water in degree F
Real T2 (unit = "degree F");//T2 for distilled water in degree F
//friction factors
parameter Real ft=0.029; //friction factor for raw water fom figure 6.14 corresponding to Reynolds Number calculated above
parameter Real fs=0.281; //friction factor for distilled water fom figure 6.14 corresponding to Reynolds Number calculated above
// Velocities
Real V_t (unit = "ft/s");//The velocity of raw water in ft/s
Real V_s (unit = "ft/s");//The velocity of distilled water in ft/s
// pressure drops
parameter Real gc=32.2;//Gravitation acceleration in ft/s^2
Real dP_t (unit = "lbf/sq.ft");//The pressure drop for tube side in lbf/sq.ft
Real dP_s (unit = "lbf/sq.ft");//The pressure drop for shell side in lbf/sq.ft

equation
At=(Nt*3.1412*ID^2)/(4*Np);
As=(Ds*C*B)/sT;
De=4*((sT/2)*(0.86*sT)-(3.1412*OD^2/8))/(3.1412*OD/2);
Re_s=(m_1/3600)*(De)/(v_1*rho_1*As);
Re_t=(m_2/3600)*(ID)/(v_2*rho_2*At);
Nu_t=0.023*(Re_t)^(4/5)*(Pr_2)^0.4;
Nu_s=0.36*(Re_s)^(0.55)*(Pr_1)^(1/3);
h_ti=Nu_t*kf_2/ID;
h_to=h_ti*ID/OD;
h_s=Nu_s*kf_1/De;
Uo=1/((1/h_to)+(1/h_s));
R=(m_2*cp_2)/(m_1*cp_1);
Ao=Nt*3.1412*OD*L;
UoAo_mccp=(Uo*Ao)/(m_2*cp_2);
t2=S*(T1-t1)+t1;
T2=T1-R*(t2-t1);
V_t=(m_2/3600)/(rho_2*At);
V_s=(m_1/3600)/(rho_1*As);
dP_t=(rho_2*V_t^2)*((ft*L*Np/ID)+4*Np)/(2*gc);
dP_s=((rho_1*V_s^2)*(fs*Ds*(Nb+1)))/(2*gc*De);
end Ex9_5;