class Ex9_7
// (a)  Determine the  UA product for the  exchanger.  (b) Calculate  the  exit temperatures for the exchanger, assuming that only the inlet temperatures are known
// properties of engine oil at (190 + 158)/2 = 174°F = 176 degree  F from appendix table C4
parameter Real rho_1 (unit = "lbm/ft^3")= 0.852*62.4; // density in lbm/ft^3 
parameter Real cp_1 (unit = "BTU/(lbm-degree Rankine) ")=0.509; // specific heat BTU/(lbm-degree Rankine) 
parameter Real v_1 (unit = "ft^2/s")= 0.404e-3; // viscosity in ft^2/s 
parameter Real kf_1 (unit = "BTU/(hr.ft.degree Rankine") = 0.08; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a_1 (unit = "ft^2/hr") = 2.98e-3; // diffusivity in ft^2/hr 
parameter Real Pr_1 = 490; // Prandtl Number 
parameter Real m_1 (unit = "lbm/hr")=39.8; // mass flow rate in lbm/min
// temperatures in degree F
parameter Real T1=190;
parameter Real T2=158;
// properties of air at (126 + 166)/2 = 146°F = 606 degree R from appendix table D1
parameter Real rho_2 (unit = "lbm/ft^3")= 0.0653; // density in lbm/ft^3 
parameter Real cp_2 (unit = "BTU/(lbm-degree Rankine) ")=0.241; // specific heat BTU/(lbm-degree Rankine) 
parameter Real v_2 (unit = "ft^2/s")= 20.98e-5; // viscosity in ft^2/s 
parameter Real kf_2 (unit = "BTU/(hr.ft.degree Rankine") = 0.01677 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a_2 (unit = "ft^2/hr") = 1.066; // diffusivity in ft^2/hr 
parameter Real Pr_2 = 0.706; // Prandtl Number 
parameter Real m_2 (unit = "lbm/hr")=67; // mass flow rate in lbm/min
// temperatures in degree F
parameter Real t1 (unit = "degree F")=126;
parameter Real t2 (unit = "degree F")=166;
// Heat Balance
Real q_air (unit = "BTU/hr");//The heat gained by air in BTU/hr
Real q_oil (unit = "BTU/hr");//The heat lost by oil in BTU/hr
// for counterflow
Real LMTD (unit = "degree F");//The LMTD for counter flow configuration in degree F
// Frontal Areas for Each Fluid Stream
Real Area_air;//The Core frontal area on the air side in sq.ft
Real Area_oil;//The Core frontal area on the oil side in sq.ft
// Correction Factors (parameters calculated first)
Real S;//Correction factor
Real R;//The ratio
parameter Real F=0.87; //value of correction factor from figure 9.21a corresponding to above calculated values of S and R
// Overall Coefficient (q = U*A*F*LMTD)
Real UA (unit = "BTU/(hr. degree R)");//The Overall Coefficient in BTU/(hr. degree R)
// determining the capacitances
Real mcp_air (unit = "BTU/(hr. degree R)");//The capacitance value of air in BTU/(hr. degree R)
Real mcp_oil (unit = "BTU/(hr. degree R)");//The capacitance value of engine oil in BTU/(hr. degree R)
Real mcp_max (unit = "BTU/(hr. degree R)");//The max. capacitance value in BTU/(hr. degree R)
Real mcp_min (unit = "BTU/(hr. degree R)");//The min. capacitance value in BTU/(hr. degree R)

// determination of parameters for determining effectiveness
Real mcp_min_max;//Ratio of max. and min. capacitances
Real NTU;//(UoAo/mcp_min)
Real effectiveness=0.62; //value of effectiveness from figure 9.21b corresponding to the above calculated values of capacitance ratio and (UoAo/mcp_min):');
Real t2_c (unit = "degree F");//The Outlet temperature for air in degree F
Real T2_c (unit = "degree F");//The Outlet temperature for Engine Oil in degree F

equation
q_air=m_2*cp_2*60*(t2-t1);
q_oil=m_1*cp_1*60*(T1-T2);
LMTD=((T1-t2)-(T2-t1))/(log((T1-t2)/(T2-t1)));
Area_air=(9.82*8)/144;
Area_oil=(3.25*9.82)/144;
S=(t2-t1)/(T1-t1);
R=(T1-T2)/(t2-t1);
UA=q_air/(F*LMTD);
mcp_air=m_2*cp_2*60;
mcp_oil=m_1*cp_1*60;
if mcp_air>mcp_oil then
    mcp_max=mcp_air;
    mcp_min=mcp_oil;
else mcp_max=mcp_oil;
   mcp_min=mcp_air;
end if;
mcp_min_max=mcp_min/mcp_max;
NTU=(UA/mcp_min);
t2_c=(T1-t1)*effectiveness+t1;
T2_c=T1-(mcp_min_max)*(t2_c-t1);
end Ex9_7;