class Ex1_1
  parameter Real q = 6.3; //heat flux (BTU/s * ft^2)
  parameter Real k (unit = "(BTU/hr.ft.*R)") = 9.4; //Thermal conductivity (BTU/hr.ft.*R)
  parameter Real T1 (unit = "Rankine")= 350; //Surface temperature of one side of the wall
  parameter Real L (unit = "feet") = 0.5/12;//Wall thickness in feet
  Real T2 (unit = "F"); //Surface temperature on other side of the wall
  equation
  q*3600 = k*(T1-T2)/L;
end Ex1_1;