class Ex12_5
//  Determination of the heat exchanged between the two plates
// The view factor can be found with the crossed-string method
// from figure 12.13(b)
parameter Real ac (unit = "feet")=1;//Length of string ac in feet
parameter Real bd (unit = "feet")=1;//Length of string bd in feet
parameter Real ad (unit = "feet")=(9+1)^0.5;//Length of crossed string ad in feet
parameter Real bc (unit = "feet")=ad;//Length of crossed string bc in feet
Real crossed_strings (unit = "feet");//Total length of crossed strings in feet
Real uncrossed_strings (unit = "feet");//Total length of uncrossed strings in feet
Real L1_F12 (unit = "feet");//The Product L1F12 in ft
parameter Real L1 (unit = "feet")=3;
Real F12;//The view factor
parameter Real sigma (unit="BTU hr^−1 ft^−2 °R^−4")=5.67e-8; // Stefan-Boltzmann constant
parameter Real T1 (unit = "degree R")=560;//Temperature of the upper plate
parameter Real T2 (unit = "degree R")=460;//Temperature of the lower plate  
Real q12_A1 (unit = "W/sq.m");//The heat transfer rate in W/sq.m

equation
crossed_strings=ad+bc;
uncrossed_strings=ac+bd;
L1_F12=(1/2)*(crossed_strings-uncrossed_strings);
F12=L1_F12/L1;
q12_A1=sigma*(T1^4-T2^4)*F12;
end Ex12_5;