class Ex2_11
import Modelica.SIunits.*;
// determination of heat transferred and fin effectiveness
//parameters of the problem are
parameter Real N=9; // number of fins
parameter Length delta=0.003/2; //Difference in lengths in m
parameter Length L=0.025;
parameter Length Lc=L+delta;
parameter Length R=0.219/2;
parameter Length R2c=R+delta;
parameter Length R1=R-L;
parameter Temperature T_w=260 + 273.15; // root wall temperature in degree celsius
parameter Temperature T_inf=27 + 273.15; // ambient temperature in degree celsius
parameter CoefficientOfHeatTransfer hc=15;//Coeff of heat transfer in W/(m^22.K)
parameter ThermalConductivity k=52; // thermal conductivity of cast iron in W/(m.K)from appendix table B2
Area Ap;//Area in m^2
Area As;//Area in m^2
Real radius_ratio; // for finding efficiency from figure 2.38
Real variable;//The value of Lc^(3/2)(hc/kAp)^(1/2)
parameter Real efficiency=0.93; // efficiency of the fin from figure 2.38
Power qf;//nThe heat transferred by the nine fins in W
parameter Length Sp=0.0127; // fin spacing
Area Asw; // exposed surface area
Power qw;//The heat transferred by exposed surface of the cylinder in W
Power q;//The total heat transferred from the cylinder is %d W
Length H;// height of cylinder
Area Aso; // surface area without fins
Power qo;//The Heat transferred without fins in W
Real effectiveness; // effectiveness defined as ratio of heat transferred with fins to heat transferred without fins
equation
Ap=2*delta*Lc;
As=2*3.1412*(R2c^2-R1^2);
radius_ratio=R2c/R1;
variable=Lc^1.5*sqrt(hc/(k*Ap));
qf=N*efficiency*As*hc*(T_w-T_inf);
Asw=2*3.14*R1*Sp*N;
qw=hc*Asw*(T_w-T_inf);
q=qf+qw;
H=N*(Sp+2*delta);
Aso=2*3.1412*R1*H;
qo=hc*Aso*(T_w-T_inf);
effectiveness=q/qo;
end Ex2_11;